external_function(name=logncdf, nargs=3);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DECLARATION OF ENDOGENOUS VARIABLES%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
var 
    V Vmodified U C H K S X I IS Sdash lambda Wh rK RPS R Q Rn PIE PIEw W Jw Hd MRSS JJw WO Deltaw YW A PWP MC Jp Y MCS JJp PO Deltap MPS G RK spread CEquiv
    rhoofpsi psiFF NE CE L Rl p Gofpsi Gammaofpsi Gammadashofpsi Gdashofpsi
    sigmaE xiE muFF sigmapsi 
    dyobs dcobs pinfobs robs labobs spreadobs dinvobs dwobs UH; // observables

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DECLARATION OF EXOGENOUS VARIABLES%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
varexo epsA epsG epsMCS epsMPS epsIS epsMRSS epsRPS;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DECLARATION OF PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
parameters gy alp delta zzetap zzetaw              // calibrated/fixed parameters
           sigma_c chi phiX xip xiw gammap gammaw PIE_bar g_bar Rn_bar // estimated parameters: structural parameters
           rho_r theta_pie theta_y theta_dy                                // estimated parameters: Taylor rule
           rhoA rhoG rhoMCS rhoMRSS rhoMPS rhoRPS rhoIS                    // estimated parameters: shock processes
           ptarget rhotarget phitarget CEtarget
           sigma_s wr psi;                                               // misc parameters

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%CALIBRATED/FIXED OF PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  gy           = 0.18;
  alp          = 0.67;
  delta        = 0.0250;
  zzetap       = 7.0;
  zzetaw       = 3.0;
  PIE_bar      = 100*0.008662984461054;
  g_bar        = 100*0.003550693291143;
  Rn_bar       = 100*0.013318469551282;

  ptarget      = 0.03;
  rhotarget    = 1+0.006901;
  phitarget    = 2.0;
  CEtarget     = 0.075;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%ESTIMATED STRUCTURAL PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  sigma_c      = 1.5;
  chi          = 0.7;
  phiX         = 2.0;
  xip          = 0.7;
  xiw          = 0.7;
  gammap       = 0.5;
  gammaw       = 0.5;
  psi          = 2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%ESTIMATED POLICY PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  rho_r        = 0.7;
  theta_pie    = 1.5;
  theta_y      = 0.3;
  theta_dy     = 0.3;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%ESTIMATED SHOCK PROCESS PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  rhoA         = 0.7;
  rhoG         = 0.7;
  rhoMCS       = 0.7;
  rhoMRSS      = 0.7;
  rhoMPS       = 0.7;
  rhoRPS       = 0.7;
  rhoIS        = 0.7;

%%%%%%%%%%%%%%%%%%%
%%MISC PARAMETERS%%
%%%%%%%%%%%%%%%%%%%

  sigma_s      = 0.01;
  wr           = 0.0;

% ----------------------------
% *** DSGE-Model-equations ***
% ----------------------------

model;
// name = '(273) Calibration of beta)'
  # g                               = g_bar/100;
  # betta                           = (PIE_bar/100+1)/(Rn_bar/100+1)/(1+g)^(-sigma_c);

% -----------------
% *** Household ***
% -----------------

[ name = '(226) Consumption equivalent variation']
  CEquiv                            = (1.01^(1-sigma_c)-1)*U + betta*(1+g)^(1-sigma_c)*CEquiv(+1);

[ name = '(185) Intertemporal welfare']
  V                                 = U+betta*(1+g)^(1-sigma_c)*V(+1);

[ name = '(185b) Modified intertemporal welfare']
  Vmodified                         = U-wr*(Rn-STEADY_STATE(Rn))^2+betta*(1+g)^(1-sigma_c)*Vmodified(+1);

[ name = '(186) Flow utility']
  U                                 = ((C-chi*C(-1)/(1+g))^(1-sigma_c))/(1-sigma_c)*exp((sigma_c-1)*H^(1+psi)/(1+psi));

[ name = '(187) Law of motion for capital']
  K                                 = (1-delta)*K(-1)/(1+g)+(1-S)*I*IS;

[ name = '(188) Investment']
  X                                 = I*(1+g)/I(-1);

[ name = '(189) Capital adjustment cost']
  S                                 = phiX*(X-1-g)^2;

[ name = '(190) Capital adjustment cost']
  Sdash                             = 2*phiX*(X-1-g);

[ name = '(191) MUC']
  lambda                            = (1-sigma_c)*U/(C-chi*C(-1)/(1+g))-betta*chi*(1-sigma_c)*U(+1)/(1+g)^(1-sigma_c)/((1+g)*C(+1)-chi*C);

[ name = '(192) Household foc for hours']
//  Wh                                = (C-chi*C(-1)/(1+g))*H^psi/(1-betta*chi*(1+g)^(1-sigma_c)*U(+1)/U*(C-chi*C(-1)/(1+g))/((1+g)*C(+1)-chi*C));
  Wh                                = -UH/lambda;

// name = '(196) Stochastic discount factor']
  # LAMBDA_LEAD                       = betta*(1+g)^(-sigma_c)*lambda(+1)/lambda;

[ name = '(193) Euler equation']
  1                                 = RPS*R(+1)*LAMBDA_LEAD;

[ name = '(195) Household foc for investment']
  1                                 = Q*(1-S-Sdash*X)*IS
                                    + LAMBDA_LEAD*Q(+1)*Sdash(+1)*X(+1)^2*IS(+1);

[ name = '(197) Fischer equation']
  R                                 = Rn(-1)/PIE;

  UH                                = -(1-sigma_c)*U*H^psi;

% --------------------
% *** Wage setting ***
% --------------------

[ name = '(198) Wage inflation']
  PIEw                              = (1+g)*W/W(-1)*PIE;

[ name = '(199) Wage setting condition I']
  Jw                                = (1/(1-1/zzetaw))*Wh*Hd*MRSS
                                    + xiw*(1+g)*LAMBDA_LEAD*(PIEw(+1)^zzetaw/PIE^(gammaw*zzetaw))*Jw(+1);

[ name = '(200) Wage setting condition II']
  JJw                               = Hd + xiw*LAMBDA_LEAD*(PIEw(+1)^zzetaw/(PIE^(gammaw*(zzetaw-1))*PIE(+1)))*JJw(+1);

[ name = '(201) Wage setting condition III']
  WO                                = Jw/(W*JJw);

[ name = '(202) Law of motion for wage level']
  1                                 = xiw*(PIE(-1)^gammaw/PIEw)^(1-zzetaw)+(1-xiw)*WO^(1-zzetaw);

[ name = '(203) Law of motion for wage dispersion']
  Deltaw                            = xiw*(PIEw^zzetaw/PIE(-1)^(zzetaw*gammaw))*Deltaw(-1)+(1-xiw)*WO^(-zzetaw);

% -------------------
% *** Retail firm ***
% -------------------

[ name = '(204) Production function']
  YW                                = (A*Hd)^alp*(K(-1)/(1+g))^(1-alp);

[ name = '(205) Firm for for labour']
  W                                 = alp*PWP*YW/Hd;

[ name = '(206) Firm foc: return on capital']
  rK                                = (1-alp)*PWP*YW/(K(-1)/(1+g));

% ---------------------
% *** Price setting ***
% ---------------------

[ name = '(207) Marginal cost']
  MC                                = PWP;

[ name = '(208) Price setting condition']
  Jp                                = (1/(1-1/zzetap))*Y*MC*MCS
                                      +xip*(1+g)*LAMBDA_LEAD*(PIE(+1)^zzetap/PIE^(gammap*zzetap))*Jp(+1);

[ name = '(209) Price setting condition']
  JJp                               = Y+xip*(1+g)*LAMBDA_LEAD*(PIE(+1)^(zzetap-1)/PIE^(gammap*(zzetap-1)))*JJp(+1);

[ name = '(210) Price setting condition']
  PO                                = Jp/JJp;

[ name = '(211) Law of motion for price level']
  1                                 = xip*(PIE(-1)^(gammap)/PIE)^(1-zzetap)+(1-xip)*(PO)^(1-zzetap);

[ name = '(212) Law of motion for price dispersion']
  Deltap                            = xip*(PIE^zzetap/PIE(-1)^(zzetap*gammap))*Deltap(-1)+(1-xip)*PO^(-zzetap);

% -----------------------
% *** Monetary policy ***
% -----------------------

[ name = '(213) Taylor rule']
  log(Rn/STEADY_STATE(Rn))          = rho_r*log(Rn(-1)/STEADY_STATE(Rn))
                                    +(1-rho_r)*(theta_pie*log(PIE/STEADY_STATE(PIE))+theta_y*log(Y/STEADY_STATE(Y))+theta_dy*log(Y/Y(-1)))
                                    +log(MPS);

[ name = '(215) Market clearing for labour)']
  H                                 = Deltaw*Hd;

[ name = '(216) Market clearing for goods']
  YW                                = Y*Deltap;

[ name = '(217) Gross real return on capital']
  RK                                = (rK+(1-delta)*Q)/Q(-1);

[ name = '(218)']
  spread                            = RK-R;

% -----------------------------
% *** Banking sector ***
% -----------------------------

  # mupsi                           = -0.5*(sigmapsi)^2; // see main text before (447)

[ name = '(439)']
  RK(+1)                            = rhoofpsi(+1)*R(+1);

[ name = '(440)']
  NE                                = (sigmaE+xiE)*(1-Gammaofpsi)*RK*Q(-1)*K(-1)/(1+g);

[ name = '(441)']
  R(+1)*(Q*K-NE)                    = RK(+1)*Q*K*(Gammaofpsi(+1)-muFF*Gofpsi(+1));

[ name = '(442)']
  rhoofpsi                          = Gammadashofpsi/((Gammaofpsi-muFF*Gofpsi)*Gammadashofpsi+(1-Gammaofpsi)*(Gammadashofpsi-muFF*Gdashofpsi));

[ name = '(443) Resource constraint']
  Y                                 = C+CE+G+I+muFF*Gofpsi*RK*Q(-1)*K(-1)/(1+g);

[ name = '(444)']
  CE                                = (1-sigmaE)*(1-xiE)*(1-Gammaofpsi)*RK*Q(-1)*K(-1)/(1+g);

[ name = '(445)']
  L                                 = Q*K-NE;

[ name = '(446)']
  psiFF                             = Rl(-1)*L(-1)/(RK*Q(-1)*K(-1))*1/PIE;

[ name = '(446)']
  p                                 = logncdf(psiFF,mupsi,sigmapsi);

[ name = '(451)']
  Gofpsi                            = normcdf(log(psiFF)/sigmapsi-sigmapsi/2);

[ name = '(452)']
  Gammaofpsi                        = Gofpsi+psiFF*(1-p);

[ name = '(460)']
  Gammadashofpsi                    = 1-p;

[ name = '(454)']
  Gdashofpsi                        = 1/(psiFF*sigmapsi*sqrt(2*(4*atan(1))))*exp(-(log(psiFF)+mupsi)^2/(2*(sigmapsi)^2)); // (see (461) for an equivalent expression)

% -----------------------
% *** Shokc processes ***
% -----------------------

[ name = '(219) Law of motion for productivity']
  log(A)-log(STEADY_STATE(A))       = rhoA*(log(A(-1))-log(STEADY_STATE(A)))+epsA;

[ name = '(220) Law of motion for government expenditure']
  log(G)-log(STEADY_STATE(G))       = rhoG*(log(G(-1))-log(STEADY_STATE(G)))+epsG;

[ name = '(221) Law of motion for price markup shock']
  log(MCS)-log(STEADY_STATE(MCS))   = rhoMCS*(log(MCS(-1))-log(STEADY_STATE(MCS)))+epsMCS;

[ name = '(232) Law of motion for wage markup shock']
  log(MRSS)-log(STEADY_STATE(MRSS)) = rhoMRSS*(log(MRSS(-1))-log(STEADY_STATE(MRSS)))+epsMRSS;

[ name = '(233) Law of motion for capital quality shock']
  log(IS)-log(STEADY_STATE(IS))     = rhoIS*(log(IS(-1))-log(STEADY_STATE(IS)))+epsIS;

[ name = '(234) Law of motion for monetary policy shock']
  log(MPS)-log(STEADY_STATE(MPS))   = rhoMPS*(log(MPS(-1))-log(STEADY_STATE(MPS)))+epsMPS;

[ name = '(235) Law of motion for risk premium shock']
  log(RPS)-log(STEADY_STATE(RPS))   = rhoRPS*(log(RPS(-1))-log(STEADY_STATE(RPS)))+epsRPS;

% -----------------------------
% *** Measurement equations ***
% -----------------------------

[ name = '(264) Measurement equation for output growth']
  dyobs                             = log(Y/Y(-1)*(1+g));

[ name = '(265) Measurement equation for consumption growth']
  dcobs                             = log(C/C(-1)*(1+g));

[ name = '(266) Measurement equation for investment growth']
  dinvobs                           = log(I/I(-1)*(1+g));

[ name = '(267) Measurement equation for real wage growth']
  dwobs                             = log(W/W(-1)*(1+g));

[ name = '(268) Measurement equation for hours']
  labobs                            = (Hd-STEADY_STATE(Hd))/STEADY_STATE(Hd);

[ name = '(269) Measurement equation for policy rate']
  robs                              = Rn-1;

[ name = '(270) Measurement equation for inflation']
  pinfobs                           = log(PIE);

[ name = '(271) Measurement equation for spread']
  spreadobs                         = spread;

// These four variables are for calibration
//  sigmaE                            = STEADY_STATE(sigmaE);
  sigmaE                            = 0.99;
  xiE                               = STEADY_STATE(xiE);
  muFF                              = STEADY_STATE(muFF);
  sigmapsi                          = STEADY_STATE(sigmapsi);
end;

shocks;
  var epsA;    stderr sigma_s;
  var epsG;    stderr sigma_s;
  var epsMCS;  stderr sigma_s;
  var epsMPS;  stderr sigma_s;
  var epsMRSS; stderr sigma_s;
  var epsRPS;  stderr sigma_s;
  var epsIS;   stderr sigma_s;
end;

steady;
check;

estimated_params;
       sigma_c,                      NORMAL_PDF,     1.50, 0.375;
       psi, , 0, ,                   NORMAL_PDF,     2.00, 0.75;
       chi,                          BETA_PDF,       0.50, 0.10;
       phiX,                         NORMAL_PDF,     2.00, 1.50/2; // SW prior on phiX/2 is N(4,1.5)
       xip,                          BETA_PDF,       0.50, 0.10;
       xiw,                          BETA_PDF,       0.50, 0.10;
       gammap,                       BETA_PDF,       0.50, 0.10;
       gammaw,                       BETA_PDF,       0.50, 0.10;

       rho_r,                        BETA_PDF,       0.75, 0.10;
       theta_pie,                    NORMAL_PDF,     1.50, 0.25;
       theta_y,                      NORMAL_PDF,     0.12, 0.05;
       theta_dy,                     NORMAL_PDF,     0.12, 0.05;

       rhoA,                         BETA_PDF,       0.50, 0.20;
       rhoG,                         BETA_PDF,       0.50, 0.20;
       rhoMCS,                       BETA_PDF,       0.50, 0.20;
       rhoMRSS,                      BETA_PDF,       0.50, 0.20;
       rhoMPS,                       BETA_PDF,       0.50, 0.20;
       rhoRPS,                       BETA_PDF,       0.50, 0.20;
       rhoIS,                        BETA_PDF,       0.50, 0.20;

       stderr epsA,                  INV_GAMMA_PDF,  0.001, 0.020;
       stderr epsG,                  INV_GAMMA_PDF,  0.001, 0.020;
       stderr epsMCS,                INV_GAMMA_PDF,  0.001, 0.020;
       stderr epsMRSS,               INV_GAMMA_PDF,  0.001, 0.020;
       stderr epsMPS,                INV_GAMMA_PDF,  0.001, 0.020;
       stderr epsRPS,                INV_GAMMA_PDF,  0.001, 0.020;
       stderr epsIS,                 INV_GAMMA_PDF,  0.001, 0.020;
end;

varobs dyobs dcobs dinvobs dwobs robs pinfobs labobs;
//varobs dyobs dcobs dinvobs spreadobs robs pinfobs labobs;

//estimation(datafile=usdata_47q1_17q4_unscaled,first_obs=75,nobs=208,mode_compute=6,presample=0,prefilter=0,plot_priors=0,lik_init=1,mh_replic=0000,mh_nblocks=2,mh_jscale=0.28,mh_drop=0.25);
estimation(datafile=usdata_47q1_17q4_unscaled,first_obs=75,nobs=208,mode_compute=0,mode_file=BGG_financial_mode,presample=0,prefilter=0,plot_priors=0,lik_init=1,mh_replic=50000,mh_nblocks=2,mh_jscale=0.28,mh_drop=0.25);

//identification(advanced=1);

//get_posterior_parameters('mode');
stoch_simul(order=2,pruning, nograph);